<?php

namespace App\Http\Resources\Website;

use App\Http\Resources\Base\TranslatableResource;

class AboutUsResource extends TranslatableResource
{
    public function toArray($request)
    {
        return [
            'title' => $this->translate('title'),
            'description' => $this->translate('description'),
            'short_description' => $this->translate('short_description'),
            'image' => asset('storage/' . $this->image),
            'sub_image' => $this->sub_image ? asset('storage/' . $this->sub_image) : null,
            'video' => $this->video,
        ];
    }
}
