<?php

namespace App\Http\Resources\Website;

use App\Http\Resources\Base\TranslatableResource;

class CategoryResource extends TranslatableResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->translate('name'),
            'image' => $this->image ? asset('storage/' . $this->image) : null,
            'alt' => $this->translate('alt'),
            'parent' => $this->whenLoaded('parent', fn() => new CategoryResource($this->parent)),
            'children' => CategoryResource::collection($this->whenLoaded('children')),
            'service_products' => ServiceProductResource::collection($this->whenLoaded('serviceProducts')),
        ];
    }
}
