<?php

namespace App\Http\Resources\Website;

use App\Http\Resources\Base\TranslatableResource;

class DoctorResource extends TranslatableResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->translate('name'),
            'specialty' => $this->translate('specialty'),
            'years_of_experience' => $this->years_of_experience,
            'image' => asset('storage/' . $this->image),
            'description' => $this->translate('description'),
            'imported' => $this->imported,
            'services' => ServiceProductResource::collection($this->whenLoaded('serviceProducts')),
        ];
    }
}
