<?php

namespace App\Http\Resources\Website;

use App\Http\Resources\Base\TranslatableResource;

class ServiceProductResource extends TranslatableResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->translate('name'),
            'description' => $this->translate('description'),
            'category' => new CategoryResource($this->whenLoaded('category')),
            'doctors' => DoctorResource::collection($this->whenLoaded('doctors')),
        ];
    }
}
