<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Category extends Model
{
    use HasFactory;

    protected $table = 'categories';
    protected $fillable = ['name', 'image', 'alt', 'parent_id'];

    // علاقة مع الأب
    public function parent()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    // علاقة مع الأبناء
    public function children()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    // الأقسام الفرعية (recursive)
    public function subCategories()
    {
        return $this->children()->with('subCategories');
    }

    // المنتجات/الخدمات التابعة لهذا القسم
    public function serviceProducts()
    {
        return $this->hasMany(ServiceProduct::class);
    }
}
