<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Doctor extends Model
{
    use HasFactory;

    protected $table = 'doctors';
    protected $fillable = [
        'name',
        'specialty',
        'years_of_experience',
        'image',
        'description',
        'imported'
    ];

    protected $casts = [
        'imported' => 'boolean',
        'years_of_experience' => 'integer',
    ];

    // علاقة Many-to-Many مع المنتجات/الخدمات
    public function serviceProducts()
    {
        return $this->belongsToMany(ServiceProduct::class, 'doctor_service_product')
            ->withTimestamps();
    }
}
