<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ServiceProduct extends Model
{
    use HasFactory;

    protected $table = 'service_products';
    protected $fillable = ['category_id', 'name', 'description'];

    // يتبع قسم فرعي
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    // علاقة Many-to-Many مع الدكاترة
    public function doctors()
    {
        return $this->belongsToMany(Doctor::class, 'doctor_service_product')
            ->withTimestamps();
    }
}
