<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('doctor_service_product', function (Blueprint $table) {
            $table->id();
            $table->foreignId('doctor_id')->constrained('doctors')->cascadeOnDelete();
            $table->foreignId('service_product_id')->constrained('service_products')->cascadeOnDelete();
            $table->timestamps();

            $table->unique(['doctor_id', 'service_product_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('doctor_service_product');
    }
};
