<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class AboutUsSeeder extends Seeder
{
    public function run(): void
    {
        DB::table('about_us')->insert([
            'title' => json_encode(['ar' => 'من نحن', 'en' => 'About Us']),
            'description' => json_encode(['ar' => 'نحن عيادة متخصصة في التجميل منذ 20 عامًا...', 'en' => 'We are a cosmetic clinic with 20 years of experience...']),
            'short_description' => json_encode(['ar' => 'التميز في التجميل', 'en' => 'Excellence in Cosmetics']),
            'image' => 'about/main.jpg',
            'sub_image' => 'about/team.jpg',
            'video' => 'https://youtube.com/watch?v=example',
            'created_at' => now(),
        ]);
    }
}
