<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PartnerSeeder extends Seeder
{
    public function run(): void
    {
        $partners = ['johnson', 'galderma', 'allergan', 'merck'];

        foreach ($partners as $i => $p) {
            DB::table('partners')->insert([
                'image' => "partners/{$p}.png",
                'alt' => json_encode(['ar' => "شريك {$p}", 'en' => "{$p} Partner"]),
                'created_at' => now(),
            ]);
        }
    }
}
