<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ServiceSeeder extends Seeder
{
    public function run(): void
    {
        $services = [
            ['home', 'تجميل الأنف', 'Rhinoplasty', 'خدمة مميزة مع أحدث التقنيات'],
            ['about_us', 'شد الوجه', 'Facelift', 'نتائج طبيعية تدوم طويلاً'],
        ];

        foreach ($services as $s) {
            DB::table('services')->insert([
                'type' => $s[0],
                'image' => 'services/' . strtolower(str_replace(' ', '-', $s[1])) . '.jpg',
                'title' => json_encode(['ar' => $s[1], 'en' => $s[2]]),
                'description' => json_encode(['ar' => $s[3] . ' بالعربي', 'en' => $s[3] . ' in English']),
                'created_at' => now(),
            ]);
        }
    }
}
