<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class StaticPageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // StaticPageSeeder.php
        DB::table('static_pages')->insert([
            'title' => json_encode(['ar' => 'سياسة الخصوصية', 'en' => 'Privacy Policy']),
            'slug' => 'privacy-policy',
            'content' => json_encode(['ar' => 'نص السياسة...', 'en' => 'Privacy text...']),
        ]);
        for ($i = 1; $i <= 10; $i++) {
            DB::table('gallery')->insert([
                'media' => "gallery/img{$i}.jpg",
                'type' => $i % 3 == 0 ? 'video' : 'image',
                'alt' => json_encode(['ar' => "معرض صور {$i}", 'en' => "Gallery Image {$i}"]),
            ]);
        }

        // SectionSeeder.php
        DB::table('sections')->insert([
            ['key' => 'hero', 'title' => json_encode(['ar' => 'مرحبا بكم', 'en' => 'Welcome']), 'description' => json_encode(['ar' => 'عيادتنا الأفضل', 'en' => 'Best Clinic Ever'])],
        ]);
    }
}
